package com.handheld.apiinstructions;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import cn.pda.serialport.SerialPort;

import com.handheld.Barcode2DDemo.Barcode2DActivity;
import com.handheld.apiinstructions.R;

public class SettingActivity extends Activity {
	private Spinner spinnerSerialport ;
	private Spinner spinnerBuadrate ;
	private Spinner spinnerPower ;
	private Button buttonSet ;
//	private TextView textTips ;
	private String[] buadrateStrs ;
	private String[] serialportStrs ;
	private String[] powerStrs ;
	
	private List<String> listBuadRate;
	private List<String> listSerialPort;
	private List<String> listPower;
	private int port = SerialPort.com0;
	private int buad = SerialPort.baudrate1200;
	private int power = SerialPort.Power_3v3;
	private String what = "";
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_setting);
		what = getIntent().getStringExtra("what");
		initView();
	}

	private void initView() {
//		textTips = (TextView) findViewById(R.id.textSettingTips);
		spinnerSerialport = (Spinner) findViewById(R.id.spinnerSerialport);
		spinnerBuadrate = (Spinner) findViewById(R.id.spinnerBuadrate);
		spinnerPower = (Spinner) findViewById(R.id.spinnerPower);
		buttonSet = (Button) findViewById(R.id.buttonOpen);
		
		buadrateStrs = getResources().getStringArray(R.array.buadrateArray);
		serialportStrs = getResources().getStringArray(R.array.serialportArray);
		powerStrs =getResources().getStringArray(R.array.powerArray);
		listBuadRate = new ArrayList<String>();
		listSerialPort = new ArrayList<String>();
		listPower = new ArrayList<String>();
		for(String buad:buadrateStrs){
			listBuadRate.add(buad);
		}
		for(String serial:serialportStrs){
			listSerialPort.add(serial);
		}
		for(String power:powerStrs){
			listPower.add(power);
		}
		
		spinnerBuadrate.setAdapter(new ArrayAdapter<String>(this, 
				android.R.layout.simple_spinner_dropdown_item,
				listBuadRate));
		spinnerSerialport.setAdapter(new ArrayAdapter<String>(this, 
				android.R.layout.simple_spinner_dropdown_item,
				listSerialPort));
		spinnerPower.setAdapter(new ArrayAdapter<String>(this, 
				android.R.layout.simple_spinner_dropdown_item,
				listPower));
		listener();
		

	}

	
	@Override
	protected void onResume() {
		super.onResume();
	}
	private void listener (){
		spinnerSerialport.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> adapter, View view,
					int position, long id) {
				port = position;
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
			}
		});
		spinnerBuadrate.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> adapter, View view,
					int position, long id) {
				String buadrate = buadrateStrs[position];
				buad = Integer.valueOf(buadrate);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				
			}
		});
		spinnerPower.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> adapter, View view,
					int position, long id) {
				switch (position) {
				case SerialPort.Power_3v3:
					power = SerialPort.Power_3v3;
					break;
				case SerialPort.Power_5v:
					power = SerialPort.Power_5v;
					break;
				case SerialPort.Power_Psam:
					power = SerialPort.Power_Psam;
					break;
				case SerialPort.Power_Rfid:
					power = SerialPort.Power_Rfid;
					break;
				case SerialPort.Power_Scaner:
					power = SerialPort.Power_Scaner;
					break;
				default:
					break;
				}
				
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				
			}
		});
		
		buttonSet.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				
				SharedPreferences preference = getSharedPreferences("serialport", Context.MODE_PRIVATE);
				Editor editor = preference.edit();
				editor.putInt(what+"port", port);
				editor.putInt(what+"baudrate", buad);
				editor.putInt(what+"power", power);
				editor.commit();
				Toast.makeText(getApplicationContext(), "Setting success!", 0).show();
				finish();
			}
		});
	}
	
	public static final int RESULT_OK = 1001;
}
